% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OutlierLocalizationDistances.R
\name{outlierLocalizationDistance}
\alias{outlierLocalizationDistance}
\title{Outlier localization distances}
\usage{
outlierLocalizationDistance(X, localrule = 0.9, whiskerrule = 3)
}
\arguments{
\item{X}{matrix p by n, being n the number of functions and p the number of grid points.}

\item{localrule}{Local distance rule: the method marks a curve as outlier if
its k order localization distances are outliers in more than local_rulex100 percent of the k-order univariate boxplots.
Default is 0.90 so a function must be at least an outlier in 90 percent of the k-order localization distances.}

\item{whiskerrule}{Parameter for the whiskers of the univariate boxplot of the localization distances of order kth. Default value is 3.}
}
\value{
A list
}
\description{
Compute the localization distances of order k of the curve \code{y0}.
}
\examples{
outliers <- outlierLocalizationDistance(outlierData, localrule = 0.9, whiskerrule = 3)
outliers$outliers_ld_rule

}
\references{
Elías, Antonio, Jiménez, Raúl and Yukich, Joe (2020). Localization processes for functional data analysis (submitted).
}
