% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{maxPartialSumd}
\alias{maxPartialSumd}
\title{Maximum of the partial sum [probability] [iid]}
\usage{
maxPartialSumd(
  k,
  score_probabilities,
  sequence_min = NULL,
  sequence_max = NULL,
  score_values = NULL
)
}
\arguments{
\item{k}{value at which calculates the probability}

\item{score_probabilities}{the probabilities for each score from lowest to greatest (Optionnaly with scores as names)}

\item{sequence_min}{minimum score (optional if \code{score_values} OR names(score_probabilities) is defined)}

\item{sequence_max}{maximum score (optional if \code{score_values} OR names(score_probabilities) is defined)}

\item{score_values}{vector of integer score values, associated to score_probabilities  (optional if
\code{sequence_min} and \code{sequence_max} OR names(score_probabilities) are defined)}
}
\value{
A double representing the probability of the maximum of the partial sum process equal to k
}
\description{
Calculates the distribution of the maximum of the partial sum process for a given value in the identically and independently distributed model
}
\details{
Implement the formula (4) of the article Mercier, S., Cellier, D., & Charlot, D. (2003). An improved approximation for assessing the statistical significance of molecular sequence features. Journal of Applied Probability, 40(2), 427-441. doi:10.1239/jap/1053003554 \cr
Important note : the calculus of the parameter of the distribution uses
the resolution of a polynome which is a function of the score distribution, of order max(score)-min(score). There exists only empirical methods to solve a polynome of order greater that 5
with no warranty of reliable solution.
The found roots are checked internally to the function and an error message is throw in case of inconsistency.
}
\examples{
maxPartialSumd(10, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -6, 4)
prob <- c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02)
score_values <- which(prob != 0) - 7 # keep only non null probability scores
prob0 <- prob[prob != 0]             # and associated probability
p <- maxPartialSumd(10, prob, sequence_min = -6, sequence_max =  4)
p0 <- maxPartialSumd(10,prob0, score_values = score_values)
p == p0 # TRUE
}
