% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logfuncs.R
\name{levellog}
\alias{levellog}
\alias{debug}
\alias{info}
\alias{warn}
\alias{error}
\alias{fatal}
\title{Write messages to logs at a given priority level.}
\usage{
levellog(logger, level, ...)

debug(logger, ...)

info(logger, ...)

warn(logger, ...)

error(logger, ...)

fatal(logger, ...)
}
\arguments{
\item{logger}{An object of class 'logger'.}

\item{level}{The desired priority level: a number, a character, or an object
of class 'loglevel'. Will be coerced using \code{\link[=as.loglevel]{as.loglevel()}}.}

\item{...}{One or more items to be written to the log at the corresponding
priority level.}
}
\description{
Write messages to logs at a given priority level.
}
\examples{

library('log4r')

logger <- create.logger(logfile = 'debugging.log', level = "WARN")

levellog(logger, 'WARN', 'First warning from our code')
debug(logger, 'Debugging our code')
info(logger, 'Information about our code')
warn(logger, 'Another warning from our code')
error(logger, 'An error from our code')
fatal(logger, "I'm outta here")
}
\seealso{
\code{\link[=loglevel]{loglevel()}}
}
