% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_classifier.R
\name{predict.randomGuess}
\alias{predict.randomGuess}
\title{Randomly Guessing Classifier Prediction}
\usage{
\method{predict}{randomGuess}(object, X, ...)
}
\arguments{
\item{object}{An object of class \code{randomGuess}, with the following attributes:
\itemize{
\item{ylabs}{\code{[K]} the ylabels for each of the \code{K} unique classes, ordered.}
\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}
}}

\item{X}{\code{[n, d]} the data to classify with \code{n} samples in \code{d} dimensions.}

\item{...}{optional args.}
}
\value{
Yhat \code{[n]} the predicted class of each of the \code{n} data point in \code{X}.
}
\description{
A function that predicts by randomly guessing based on the pmf of the class priors. Functionality consistent
with the standard R prediction interface so that one can compute the "guess" accuracy
with minimal modification of other classification scripts.
}
\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.classify.randomGuess(X, Y)
Yh <- predict(model, X)
}
\author{
Eric Bridgeford
}
