% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosssectional_consensus_cluster.R
\name{crosssectional_consensus_cluster}
\alias{crosssectional_consensus_cluster}
\title{Cross-sectional clustering with categorical variables}
\usage{
crosssectional_consensus_cluster(
  data,
  reps = 1000,
  finalLinkage = "ward.D2",
  innerLinkage = "ward.D2",
  ...
)
}
\arguments{
\item{data}{a matrix or data.frame containing variables that should be used
for computing the distance. This argument is passed to \code{StatMatch::gower.dist}}

\item{reps}{number of repetitions, same as in \code{ConsensusClusterPlus}}

\item{finalLinkage}{linkage method for final clustering,
same as in \code{ConsensusClusterPlus}same as in \code{ConsensusClusterPlus}}

\item{innerLinkage}{linkage method for clustering steps,
same as in \code{ConsensusClusterPlus}}

\item{...}{other arguments passed to \code{ConsensusClusterPlus}, attention:
the \code{d} argument can \bold{not} be set as it is directly computed by
\code{crosssectional_consensus_cluster}}
}
\value{
The output is produced by \code{ConsensusClusterPlus}
}
\description{
This function uses the \code{ConsensusClusterPlus} function from the package
with the same name with defaults for clustering data with categorical
variables. As the distance function, the Gower distance is used.
}
\details{
\code{data} can take all input data types that \code{\link[StatMatch]{gower.dist}}
can handle, i.e. \code{numeric}, \code{character}/\code{factor}, \code{ordered}
and \code{logical}.
}
\examples{
dc <- mtcars
# scale continuous variables
dc <- sapply(mtcars[, 1:7], scale)
# code factor variables
dc <- cbind(as.data.frame(dc),
            vs = as.factor(mtcars$vs),
            am = as.factor(mtcars$am),
            gear = as.factor(mtcars$gear),
            carb = as.factor(mtcars$carb))
cc <- crosssectional_consensus_cluster(
  data = dc,
  reps = 10,
  seed = 1
)
}
