% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crp.R
\name{crp}
\alias{crp}
\title{Conditional Response Probability}
\usage{
crp(data, position, answer, id, key, scored)
}
\arguments{
\item{data}{a dataframe of the scored free recall that you would
like to calculate - use prop_correct_free() for best formatting.}

\item{position}{a column name in the dataframe that contains
answered position of each response in quotes (i.e., "column")}

\item{answer}{a column name of the answer given for that position
in the original dataframe.}

\item{id}{a column name of the participant id in the original
dataframe.}

\item{key}{a vector containing the scoring key or data column name.
This column does not have to be included in the original dataframe.
We assume your answer key is in the tested position order. You should
not include duplicates in your answer key.}

\item{scored}{a column in the original dataframe indicating if the
participant got the answer correct (1) or incorrect (0).}
}
\value{
\item{DF_CRP}{A dataframe of the proportion correct for each
conditional lag position including any other between subjects
variables present in the data.}
}
\description{
This function calculates the conditional response
probability of each lag position. Participants' lag
between subsequent named items is tallied and then
divided by the possible combination of subsequent lags
given their response pattern.
}
\details{
This output can then be used to create a CRP visualizations,
and an example can be found in our manuscript/vignettes.

Important: The code is written assuming the data provided are for
a single recall list. If repeated measures are used (i.e., there are
multiple lists completed by each participant or multiple list versions),
you should use this function several times, once on each list/answer key.
}
\examples{

data(free_data)
data(answer_key_free2)

free_data <- subset(free_data,
 List_Type == "Cat_Recall_L1")

DF_long <- arrange_data(data = free_data,
 responses = "Response",
 sep = " ",
 id = "Username")

scored_output <- prop_correct_free( data = DF_long,
 responses = "response",
 key = answer_key_free2$Answer_Key,
 id = "Sub.ID",
 cutoff = 1,
 flag = TRUE,
 group.by = "Version")

crp_output <- crp(data = scored_output$DF_Scored,
 position = "position",
 answer = "Answer",
 id = "Sub.ID",
 key = answer_key_free2$Answer_Key,
 scored = "Scored")

 head(crp_output)

}
\keyword{correct}
\keyword{free}
\keyword{position}
\keyword{proportion}
\keyword{recall}
\keyword{scoring}
\keyword{serial}
