% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serial_position_multiple.R
\name{serial_position_multiple}
\alias{serial_position_multiple}
\title{Serial Position Calculator for Multiple Lists}
\usage{
serial_position_multiple(
  data,
  position,
  answer,
  key,
  key.trial,
  id.trial,
  scored,
  group.by = NULL
)
}
\arguments{
\item{data}{a dataframe of the scored free recall that you would
like to calculate - use prop_correct_multiple() for best formatting.}

\item{position}{a column name in the dataframe that contains
answered position of each response in quotes (i.e., "column")}

\item{answer}{a column name of the answer given for that position
in the original dataframe.}

\item{key}{a vector containing the scoring key or data column name.
This column does not have to be included in the original dataframe.
We assume your answer key is in the tested position order. You should
not include duplicates in your answer key.}

\item{key.trial}{a vector containing the trial numbers for each answer.
Note: If you input long data (i.e., repeating trial-answer responses),
we will take the unique combination of the responses. If a trial number
is repeated, you will receive an error. Key and key.trial can also be
a separate dataframe, depending on how your output data is formatted.}

\item{id.trial}{a column name containing the trial numbers
for the participant data from the original dataframe. Note that
the free response "key" trial and this trial number should match.
The trial key will be repeated for each answer a participant gave.}

\item{scored}{a column in the original dataframe indicating if the
participant got the answer correct (1) or incorrect (0).}

\item{group.by}{an optional argument that can be used to group the
output by condition columns. These columns should be in the original
dataframe and concatenated c() if there are multiple columns}
}
\value{
\item{DF_Serial}{A dataframe of the proportion correct for each
tested position by any optional grouping variables included.}
}
\description{
This function calculates the proportion correct of each item in the
serial position curve. Data should include the participant's answers
in long format (use arrange_data() in this package for help), the answer
key of the items in order, and a column that denotes the order a
participant listed each item. The function will then calculate
the items remembered within a window of 1 before or 1 after the
tested position. The first and last positions must be answered in the
correct place. Specifically, this function is an extension of
serial_position() for free recall when there are multiple lists
or randomized lists.
}
\details{
This output can then be used to create a serial position curve visualizations,
and an example can be found in our manuscript/vignettes.
}
\examples{

data("multi_data")
data("multi_answers")

DF_long <- arrange_data(data = multi_data,
                       responses = "Response",
                       sep = " ",
                       id = "Sub.ID",
                       repeated = "List.Number")

library(reshape)
multi_answers$position <- 1:nrow(multi_answers)
answer_long <- melt(multi_answers,
                    measured = colnames(multi_answers),
                    id = "position")
colnames(answer_long) <- c("position", "List.ID", "Answer")

answer_long$List.ID <- gsub(pattern = "List",
                            replacement = "",
                            x = answer_long$List.ID)

DF_long$response <- tolower(DF_long$response)
answer_long$Answer <- tolower(answer_long$Answer)
answer_long$Answer <- gsub(" ", "", answer_long$Answer)

scored_output <- prop_correct_multiple(data = DF_long,
                                    responses = "response",
                                    key = answer_long$Answer,
                                    key.trial = answer_long$List.ID,
                                    id = "Sub.ID",
                                    id.trial = "List.Number",
                                    cutoff = 1,
                                    flag = TRUE)

head(scored_output$DF_Scored)

head(scored_output$DF_Participant)


serial_output <- serial_position_multiple(data = scored_output$DF_Scored,
                                         position = "position",
                                         answer = "Answer",
                                         key = answer_long$Answer,
                                         key.trial = answer_long$List.ID,
                                         scored = "Scored",
                                         id.trial = "List.Number")

 head(serial_output)

}
\keyword{correct}
\keyword{free}
\keyword{position}
\keyword{proportion}
\keyword{recall}
\keyword{scoring}
\keyword{serial}
