% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/and_vertebrates_doc.R
\docType{data}
\name{and_vertebrates}
\alias{and_vertebrates}
\title{Cutthroat trout and salamander length and weights in Mack Creek, Andrews Forest LTER}
\format{
A tibble with 32,209 rows and 16 variables:
\describe{
\item{year}{a number indicating the observation year}
\item{sitecode}{a character denoting the coded name of sample area}
\item{section}{a character denoting the section in Mack Creek (CC = clear cut forest, OG = upstream old growth coniferous forest)}
\item{reach}{a character denoting the reach sampled from each section; L = lower reach (0 - 50 meters), M = middle reach (50 - 100 meters), U = upper reach (100 - 150 meters))}
\item{pass}{a number denoting the electroshocking pass number, either 1 or 2}
\item{unitnum}{a number denoting the channel unit number}
\item{unittype}{a character denoting the channel unit classification type (C = cascade, I = riffle, IP = isolated pool (not connected to channel), P = pool, R = rapid, S = step (small falls), SC = side channel, NA = not sampled by unit)}
\item{vert_index}{a number denoting the unique index for each vertebrate}
\item{pitnumber}{a number denoting the unique tag number embedded into vertebrate (tagging started in 2007)}
\item{species}{a character denoting species measured}
\item{length_1_mm}{a number denoting vertebrate length in millimeters; total or snout-fork length for trout, and snout-vent length for salamanders}
\item{length_2_mm}{a number denoting snout-tail length in millimeters (for Coastal giant salamander only)}
\item{weight_g}{a number denoting vertebrate mass in grams}
\item{clip}{a character denoting the fin clip type for cutthroat trout, ended in 2006 (LV = left ventral fin; LVRV = left and right ventral fins; RV = right ventral fin; NONE = no ventral fin clip)}
\item{sampledate}{a date denoting the date of observation}
\item{notes}{a character denoting additional comments}
}
}
\source{
{Gregory, S.V. and I. Arismendi. 2020. Aquatic Vertebrate Population Study in Mack Creek, Andrews Experimental Forest, 1987 to present ver 14. Environmental Data Initiative.}
\doi{10.6073/pasta/7c78d662e847cdbe33584add8f809165}
}
\usage{
and_vertebrates
}
\description{
Includes count and size data for cutthroat trout and salamanders in clear cut or old growth sections of Mack Creek, Andrews Forest LTER.
}
\keyword{datasets}
