% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{label}
\alias{label}
\title{Attach labels to data and variables}
\usage{
label(data, ...)
}
\arguments{
\item{data}{data.frame}

\item{...}{For variable label, \code{Var = "Var Label"}:
For data label, \code{"Example data lable"}.}
}
\value{
data.frame
}
\description{
\code{label()} manipulates labels
}
\details{
\strong{Attach labels}

It has two inputs. If only one label is specified, that
label is attached to the data. Otherwise, the pattern
\code{Var = "Var Label"} are used to attach labels to variables.

\strong{Remove labels}

\code{NA} or \code{NULL} is used to remove labels.
}
\examples{

## Variable label
x <- label(infert,
           education = "Education levels",
           age = "Age in years of case",
           parity = "count",
           stratum = "1-83",
           pooled.stratum = "1-63")

## Data label
x <- label(x, "Infertility and Abortion Dataset")
codebook(x)

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
