% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapping_pack.R
\name{get.Acciones}
\alias{get.Acciones}
\title{Colombian Assets extraction}
\usage{
get.Acciones(accion = "BCOLOMBIA", verbose = FALSE)
}
\arguments{
\item{accion}{The asset's ticket. \cr
The assets available are: \cr
 \itemize{
 \item Bancolombia: "BCOLOMBIA";
 \item Ecopetrol: "ECOPETROL";
 \item Exito: "EXITO";
 \item Avianca: "AVIANCA";
 \item Grupo Sura: "GRUPOSURA";
 \item Grupo Aval: "GRUPOAVAL";
 \item ETB: "ETB";
 }}

\item{verbose}{print the dates already extracted. Default FALSE.
Default is "BCOLOMBIA".}
}
\value{
The dataframe with dates and the asset prices and volume.
}
\description{
Function to extract the price and volume time series of some Colombian assets from the "Bolsa de Valores de Colombia" (BVC).
If it takes more than 5 minutes is because the BVC's Server is not correctly working and it is better to try later.
}
\examples{
\dontrun{
BCOLOMBIA <- get.Acciones("BCOLOMBIA");
ECOPETROL <- get.Acciones("ECOPETROL");
EXITO <- get.Acciones("EXITO");
AVIANCA <- get.Acciones("AVIANCA");
}
}
