% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-unit_checks.R
\name{check_name_standards}
\alias{check_name_standards}
\title{Assess variable names in a data dictionary for non-standard formats}
\usage{
check_name_standards(var_names)
}
\arguments{
\item{var_names}{A character vector of names.}
}
\value{
A data frame providing non-standard names across a vector.
}
\description{
Generates a data frame report of any variable names that are not compatible
in Maelstrom Research ecosystem, including Opal.
This report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.
}
\details{
The object may be specifically formatted to be compatible with additional
\href{https://maelstrom-research.org/page/software}{Maelstrom Research software},
in particular \href{https://www.obiba.org/pages/products/opal/}{Opal environments}.
}
\examples{
{

# use madshapR_examples provided by the package
names_in_data_dict <- 
  madshapR_examples$`data_dictionary_example - errors`$`Variables`$`name`
check_name_standards(names_in_data_dict)
check_name_standards(c("coucou", "cou cou", "$coucou",NA))

}

}
