% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_unique.R
\name{make_unique}
\alias{make_unique}
\title{Make Values Unique}
\usage{
make_unique(
  x,
  sep = " ",
  wrap_in_brackets = TRUE,
  warn_about_type_conversion = TRUE
)
}
\arguments{
\item{x}{vector to de-duplicate}

\item{sep}{string separating (string)}

\item{wrap_in_brackets}{should the number indicating order of duplicated elements be wrapped in round brackets? (flag)}

\item{warn_about_type_conversion}{should the function warn user if input type is converted to 'character' in output (flag)}
}
\value{
x but duplicated values are de-duplicated by adding a number corresponding to the order in which duplicates appear
}
\description{
Append numbers to duplicate values to ensure all are unique
}
\details{
Differs from 'make.unique' in base R by starting suffixes at 1 and allowing users to customize suffix format.
}
\examples{
make_unique(c('bob', 'billy', 'bob', 'bob'))
}
