% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPR.R
\name{getPR}
\alias{getPR}
\title{Download PR points from the MAP database}
\usage{
getPR(
  country = NULL,
  ISO = NULL,
  continent = NULL,
  species = NULL,
  extent = NULL,
  start_date = NULL,
  end_date = NULL,
  version = NULL
)
}
\arguments{
\item{country}{string containing name of desired country, e.g. \code{ c("Country1", "Country2", ...)} OR \code{ = "ALL"}. (Use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{ISO}{string containing ISO3 code for desired country, e.g. \code{c("XXX", "YYY", ...)} OR \code{ = "ALL"}. (Use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{continent}{string containing continent (one of "Africa", "Americas", "Asia", "Oceania") for desired data, e.g. \code{c("continent1", "continent2", ...)}. (Use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{species}{string specifying the Plasmodium species for which to find PR points, options include: \code{"Pf"} OR \code{"Pv"} OR \code{"BOTH"}}

\item{extent}{an object specifying spatial extent within which PR data is desired, as returned by sf::st_bbox() - the first column has the minimum, the second the maximum values; rows 1 & 2 represent the x & y dimensions respectively (matrix(c("xmin", "ymin","xmax", "ymax"), nrow = 2, ncol = 2, dimnames = list(c("x", "y"), c("min", "max"))))}

\item{start_date}{string object representing the lower date to filter the PR data by (inclusive) e.g. '2020-01-01'}

\item{end_date}{string object representing the upper date to filter the PR data by (exclusive) e.g. '2020-01-01'}

\item{version}{(optional) The PR dataset version to return. If not provided, will just use the most recent version of PR data. (To see available version options, 
use listPRPointVersions)}
}
\value{
\code{getPR} returns a dataframe containing the below columns, in which each row represents a distinct data point/ study site.

\enumerate{
\item \code{dhs_id} The dhs survey id if appropriate.
\item \code{site_id} Unique site identifier
\item \code{site_name} Name of site.
}
}
\description{
\code{getPR} downloads all publicly available PR points for a specified country (or countries) and returns this as a dataframe.
}
\details{
\code{country} and \code{ISO} refer to countries and a lower-level administrative regions such as Mayotte and French Guiana.
While we cannot direectly distribute DHS coordinates, we can distribute the number of examined and positive. If the coordinates
are needed they can be downloaded from www.measuredhs.com, via the rdhs package or using malariaAtlas:fillDHSCoordinates().
}
\examples{
#Download PfPR data for Nigeria and Cameroon and map the locations of these points using autoplot
\dontrun{
NGA_CMR_PR <- getPR(country = c("Nigeria", "Cameroon"), species = "Pf")
autoplot(NGA_CMR_PR)

#Download PfPR data for Madagascar and map the locations of these points using autoplot
Madagascar_pr <- getPR(ISO = "MDG", species = "Pv")
autoplot(Madagascar_pr)

getPR(country = "ALL", species = "BOTH")
}


}
\seealso{
\code{autoplot} method for quick mapping of PR point locations (\code{\link{autoplot.pr.points}}).
}
