
<!-- README.md is generated from README.Rmd. Please edit that file -->
<img align="right" src="data:image/png;base64,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" style="max-width: 300px">

mandelbrot
==========

<!-- [![travis\_status](https://travis-ci.org/blmoore/mandelbrot.svg?branch=master)](https://travis-ci.org/blmoore/mandelbrot) [![codecov](https://codecov.io/gh/blmoore/mandelbrot/branch/master/graph/badge.svg)](https://codecov.io/gh/blmoore/mandelbrot) [![CRAN\_badge](http://www.r-pkg.org/badges/version/mandelbrot)](https://cran.r-project.org/package=mandelbrot) -->

Curious whether your favourite complex number is a member of the Mandelbrot set?

—No? Then probably you just want to draw pretty pictures.

Install with:

``` r
devtools::install_github("blmoore/mandelbrot")
```

Examples
--------

``` r
library(mandelbrot)

mb <- mandelbrot()
plot(mb)
```

Pretty colours:

``` r
mb <- mandelbrot(xlim = c(-0.8438146, -0.8226294),
                 ylim = c(0.1963144, 0.2174996), 
                 iterations = 500, resolution = 800)

cols <- mandelbrot_palette(RColorBrewer::brewer.pal(11, "Spectral"), fold = FALSE)
plot(mb, col = cols)
```

Experiment with transforms:

``` r
# layout config (reset after)
par(mfrow = c(1, 2), pty = "s", mar = rep(0, 4))
plot(mb, col = cols, transform = "inverse")
plot(mb, col = cols, transform = "log")
```

Don't like `image`? Convert to a `data.frame` and use with ggplot2:

``` r
library(ggplot2)

mb <- mandelbrot(xlim = c(-0.8335, -0.8325),
                 ylim = c(0.205, 0.206), 
                 resolution = 1200L,
                 iterations = 1000)

# weird uneven palette made for a heatmap viz:
# https://benjaminlmoore.wordpress.com/2015/04/09/recreating-the-vaccination-heatmaps-in-r/
cols <- c(
  colorRampPalette(c("#e7f0fa", "#c9e2f6", "#95cbee",
                     "#0099dc", "#4ab04a", "#ffd73e"))(10),
  colorRampPalette(c("#eec73a", "#e29421", "#e29421", 
                     "#f05336","#ce472e"), bias=2)(90), 
  "black")

df <- as.data.frame(mb)
ggplot(df, aes(x = x, y = y, fill = value)) +
  geom_raster(interpolate = TRUE) + theme_void() +
  scale_fill_gradientn(colours = cols, guide = "none") 
```

`mandelbrot0` is a faster interface for `as.data.frame(mandelbrot(...))`.

See also
--------

[shinybrot](https://github.com/blmoore/shinybrot) is a Shiny web app that enables interactive exploration of the Mandelbrot set as generated by this package.

Hosted on shinyapps: <https://blmr.shinyapps.io/shinybrot>

Credits
-------

-   Wraps original R / C code by [mariodosreis](https://github.com/mariodosreis) (see R package [fractal](https://github.com/mariodosreis/fractal)).
