% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cf1.R
\name{cf1.param}
\alias{cf1.param}
\title{Create CF1 with data information}
\usage{
cf1.param(data, size, options, ...)
}
\arguments{
\item{data}{A dataframe}

\item{size}{An integer for the number of phases}

\item{options}{A list of options for EM steps}

\item{...}{Others. This can provide additional options for EM steps.}
}
\description{
Crate CF1 with the first moment of a given data. This function calls cf1.param.linear
and cf1.param.power to determine CF1. After execute 5 EM steps, the model with the smallest
LLF is selected.
}
\examples{
## Generate group data
dat <- data.frame.phase.group(c(1,2,0,4), seq(0,10,length.out=5))

## Create an instance of CF1
p <- cf1.param(data=dat, size=5)

}
