% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.AllClasses.R
\docType{class}
\name{march.Mtd-class}
\alias{march.Mtd-class}
\title{A Mixture Transition Distribution (MTD) model.}
\description{
This class describes a Mixture Transition Distribution (MTD) model, represented by its transition matrix Q,
its vector phi of lag parameters and its order. march.Mtd extends \code{\link{march.Model-class}} class and therefore
inherits its slots.
march.Mtd extends \code{\link{march.Model-class}} class and therefore inherits its slots.
}
\details{
The model used here is described into :
\itemize{
 \item Raftery, A. E. A Model for High-Order Markov Chains. 
 JRSS B 47(1985), pp. 528-539.
 \item Berchtold, A. Estimation in the mixture transition distribution model.
 Journal of Time Series Analysis, 22 (4) (2001), pp. 379-397
}

 @section Slots:
 \describe{
   \item{\code{Q}:}{A matrix of \code{\link{numeric}} representing the transition matrix associated with the 
   current MTD model.}
   \item{\code{S}:}{A list of matrices of \code{\link{numeric}} representing the transition matrices between the covariates and the dependent variable}
   \item{\code{phi}:}{A vector of \code{\link{numeric}} representing the vector of lag parameters.}
   \item{\code{order}:}{An \code{\link{integer}} representing the order of the model.}
 }
}
\seealso{
\code{\link{march.mtd.construct}}, \code{\link{march.Model-class}}.
}
