% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMMLikelihood.r
\name{HMMLikelihood}
\alias{HMMLikelihood}
\alias{reals}
\alias{hmm.lnl}
\title{Hidden Markov Model likelihood functions}
\usage{
HMMLikelihood(par,type,xx,xstart,mx,T,freq=1,fct_dmat,fct_gamma,fct_delta,ddl,
                         dml,parameters,debug=FALSE,return.mat=FALSE,sup=NULL,check=FALSE)
       reals(ddl,dml,parameters,parlist,indices=NULL)
       hmm.lnl(x,start,m,T,dmat,gamma,delta,freq,debug)
}
\arguments{
\item{par}{vector of parameter values for log-likelihood evaluation}

\item{type}{vector of parameter names used to split par vector into types}

\item{xx}{matrix of observed sequences (row:id; column:occasion/time); xx used instead of x to avoid conflict in optimx}

\item{xstart}{for each ch, the first non-zero x value and the occasion of the first non-zero value; ; xstart used instead of start to avoid conflict in optimx}

\item{mx}{number of states; mx used instead of m to avoid conflict in optimx}

\item{T}{number of occasions; sequence length}

\item{freq}{vector of history frequencies or 1}

\item{fct_dmat}{function to create D from parameters}

\item{fct_gamma}{function to create gamma - transition matrix}

\item{fct_delta}{function to create initial state distribution}

\item{ddl}{design data list of parameters for each id}

\item{dml}{list of design matrices; one entry for each parameter; each entry contains fe and re for fixed and random effects}

\item{parameters}{formulas for each parameter type}

\item{debug}{if TRUE, print out par values and -log-likelihood}

\item{return.mat}{If TRUE, returns list of transition, observation and delta arrays.}

\item{sup}{list of supplemental information that may be needed by the function but only needs to be computed once; currently only used for MVMS models for dmat}

\item{check}{if TRUE, checks validity of gamma, dmat and delta to look for any errors}

\item{x}{same as xx but for call to hmm.lnl}

\item{m}{same as mx but for call to hmm.lnl}

\item{dmat}{observation probability matrices}

\item{gamma}{transition matrices}

\item{delta}{initial distribution}

\item{parlist}{list of parameter strings used to split par vector}

\item{start}{same as xstart but for hmm.lnl}

\item{indices}{specific indices for computation unless NULL}
}
\value{
HMMLikelihood returns log-likelihood for a single sequence and
hmm.lnl returns the negative log-likelihood value for each capture history. reals
returns either the column dimension of design matrix for parameter or the real parameter vector
}
\description{
Function HMMLikelihood computes the log-likelihood via hmm.lnl which is a wrapper for the
FORTRAN code hmm_like.f.  The function HMMlikelihood is called from optimizer and it in turn calls hmm.lnl after
setting up parameters.
 
For an R version of the HMMLikelihood and related code see \code{\link{R_HMMLikelihood}}
}
\references{
Zucchini, W. and I.L. MacDonald. 2009. Hidden Markov Models for Time Series: An Introduction using R. Chapman and Hall, Boca Raton, FL. 275p.
}
\seealso{
R_HMMLikelihood
}
\author{
Jeff Laake
}
