% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{format.maskr_masked}
\alias{format.maskr_masked}
\alias{as.character.maskr_masked}
\title{Display and write masked vectors}
\usage{
\method{format}{maskr_masked}(x, ..., rep = getOption("maskr.replacement", "n.p."))

\method{as.character}{maskr_masked}(x, ..., rep = getOption("maskr.replacement", "n.p."))
}
\arguments{
\item{x}{A masked vector.}

\item{...}{For \code{format()}, passed to other format methods. For
\code{as.character()}, ignored.}

\item{rep}{A single character value that defines a string to show instead of
the underlying value for data that is masked.}
}
\value{
A character vector with masked values replaced by \code{rep}.
}
\description{
Masked vectors generally cannot be converted to other types without
\link{unmask}ing them. However, they can be written as character vectors (losing
the underlying masked data) for printing to the console, and saving to files.
}
\examples{
abc <- masked(letters, letters \%in\% c('a', 'e', 'i', 'o', 'u'))
# Prints with default n.p. label - uses format() under the hood
print(abc)

# Format as string with * instead of n.p.
format(abc, rep = '*')
print(abc, rep = '*') # Also works with print()

as.character(abc) # Similar to format(), but without alignment

# Dispatches format to underlying data
nums <- masked(
  c(1:12, NA, NA, 15:26),
  rep_len(c(FALSE, FALSE, FALSE, TRUE, FALSE), 26L)
)
print(nums)
print(nums, rep = '*') # Automatically right-aligned for numeric types

# as.character() useful for saving tables without revealing data
alphanum <- data.frame(alpha = abc, num = nums)
write.csv(head(alphanum))
}
