% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/masked.R
\name{masked}
\alias{masked}
\alias{unmask}
\alias{unmask<-}
\alias{mask}
\alias{mask<-}
\title{Create a masked atomic vector}
\usage{
masked(data = numeric(), mask = logical())

unmask(masked)

unmask(masked) <- value

mask(masked)

mask(masked) <- value
}
\arguments{
\item{data}{An atomic vector to mask values from. Lists and data frames are
not supported.}

\item{mask}{A logical vector that indicates which values of \code{data} to mask.}

\item{masked}{A masked vector to extract fields from.}

\item{value}{A replacement vector for unmasked data, or the mask flags.}
}
\value{
A masked vector.
}
\description{
Masked vectors contain a base R data type that can be used in calculations,
but is not revealed by default on the console or when converted to a
character. This can be useful for preventing publication of small cells, such
as in official statistics.
}
\section{Pretty printing and conversion to character}{


Masked vectors have pretty printing that replaces masked values of a vector
with \code{n.p.} in the console (customisable with \code{options(maskr.replacement = ...)}).

Converting a masked vector to character results in masked vectors being
replaced with \code{n.p.}, or its alternative in
\code{getOption('maskr.replacement')}.

Masked vectors cannot be converted to their raw types, to prevent
accidental release of data. Instead, use \code{\link[=unmask]{unmask()}} to explicitly unmask a
vector.
}

\section{Arithmetic and unary mathematical functions}{


Elementwise arithmetic operators have been implemented in masked vectors.
The resulting data will be as if performing the operation on the unmasked
vectors. Mask flags are sticky; the result of any operation involving a
masked value will also be masked.

Most \link{Math} and \link{Summary} group generics have been implemented. These first
force the underlying data to double type (or logical for \code{any()} and
\code{all()}). Results from summary functions will be masked if any input is
masked, while elementwise operations will preserve the mask from their
input. Cumulative functions (\code{cumsum()}, \code{cummean()} and friends) are not
implemented.
}

\examples{
# Mask vowels in the alphabet
masked(letters, letters \%in\% c('a', 'e', 'i', 'o', 'u'))

# Mask doubles...
sepals <- head(masked(iris$Sepal.Length, iris$Sepal.Length > 5))
sepals
# ...and get back the underlying values
unmask(sepals)

# Use a different mask character
op <- options(maskr.replacement = '*')
sepals
options(op)

# Mask integers in a vector strictly between 0 and 5
x <- 0:8
xm <- masked(x, 0L < x & x < 5L)

# Arithmetic with unmasked values does not change mask:
xm / xm[8] * 100
2 ^ xm
# But arithmetic with a masked value will mask outputs:
xm + xm[3]
xm - rev(xm)

# The mean will be masked, because at least one if its inputs is masked
mean(xm)
unmask(mean(xm))

# Other mathematical functions will keep the same mask
log1p(xm)
unmask(log1p(xm))
}
