% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.calibCert.R
\name{plot.calibCert}
\alias{plot.calibCert}
\title{S3 method for plotting objects of class \code{"calibCert"}}
\usage{
\method{plot}{calibCert}(x, error = TRUE, y0line = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{"calibCert"}.}

\item{error}{logical. If \code{TRUE} (the default), the indication error is
plotted. If \code{FALSE} the conventional mass correction is
plotted instead.}

\item{y0line}{Logical. If \code{TRUE} (the default) a horizontal
line is drawn at y = 0.}

\item{...}{Other graphical parameters used in \code{\link[graphics]{plot}}}
}
\value{
A base plot with calibration data of indication error or correction.
}
\description{
The function plots the indication error or the conventional
mass correction for a balance whose
calibration data is in a object of class \code{"calibCert"}.
}
\examples{
data(MT.XPE.204)
plot(MT.XPE.204)
}
\seealso{
\code{\link[=calibCert]{calibCert()}}, \code{\link[=print.calibCert]{print.calibCert()}}
}
