/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.cp.solver.constraints.set.AbstractBoundOfASet;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;

public final class MinOfASet
extends AbstractBoundOfASet {
    protected final IStateInt indexOfMinimumVariable;

    public MinOfASet(IEnvironment environment, IntDomainVar[] intvars, SetVar setvar, AbstractBoundOfASet.EmptySetPolicy emptySetPolicy) {
        super(environment, intvars, setvar, emptySetPolicy);
        this.indexOfMinimumVariable = environment.makeInt(-1);
    }

    @Override
    protected boolean removeFromEnv(int idx) throws ContradictionException {
        return this.removeLowerFromEnv(idx, this.ivars[0].getInf());
    }

    @Override
    protected int updateIndexOfCandidateVariable() {
        int minMin = Integer.MAX_VALUE;
        int minMinIdx = -1;
        int minMin2 = Integer.MAX_VALUE;
        DisposableIntIterator iter = this.getSetDomain().getEnveloppeIterator();
        while (iter.hasNext()) {
            int idx = iter.next() + 1;
            int val = this.ivars[idx].getInf();
            if (val <= minMin) {
                minMin2 = minMin;
                minMin = val;
                minMinIdx = idx;
                continue;
            }
            if (val >= minMin2) continue;
            minMin2 = val;
        }
        iter.dispose();
        return minMin2 > this.ivars[0].getSup() ? minMinIdx : -1;
    }

    protected final int minInf() {
        if (this.isNotEmptySet()) {
            int min = Integer.MAX_VALUE;
            DisposableIntIterator iter = this.getSetDomain().getEnveloppeIterator();
            while (iter.hasNext()) {
                int val = this.ivars[1 + iter.next()].getInf();
                if (val >= min) continue;
                min = val;
            }
            iter.dispose();
            return min;
        }
        return Integer.MIN_VALUE;
    }

    protected final int minSup() {
        int min = Integer.MAX_VALUE;
        DisposableIntIterator iter = this.getSetDomain().getKernelIterator();
        while (iter.hasNext()) {
            int val = this.ivars[1 + iter.next()].getSup();
            if (val >= min) continue;
            min = val;
        }
        iter.dispose();
        return min;
    }

    protected final void updateKernelInf() throws ContradictionException {
        int minValue = this.ivars[0].getInf();
        DisposableIntIterator iter = this.svars[0].getDomain().getKernelIterator();
        while (iter.hasNext()) {
            this.ivars[1 + iter.next()].updateInf(minValue, this, false);
        }
        iter.dispose();
    }

    @Override
    public void filter() throws ContradictionException {
        do {
            this.updateBoundInf(this.minInf());
        } while (this.remFromEnveloppe());
        this.updateBoundSup(this.minSup());
        this.updateKernelInf();
        this.onlyOneCandidatePropagation();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx >= 2) {
            int i = idx - 2;
            if (this.isInEnveloppe(i)) {
                do {
                    this.updateBoundInf(this.minInf());
                } while (this.remFromEnveloppe());
                this.onlyOneCandidatePropagation();
            }
        } else {
            while (this.remFromEnveloppe()) {
                this.updateBoundInf(this.minInf());
            }
            this.updateKernelInf();
            this.onlyOneCandidatePropagation();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        int i;
        if (idx >= 2 && this.isInEnveloppe(i = idx - 2)) {
            if (this.isInKernel(i)) {
                this.updateBoundSup(this.minSup());
            } else {
                while (this.remFromEnveloppe()) {
                    this.updateBoundInf(this.minInf());
                }
            }
        }
        this.onlyOneCandidatePropagation();
    }

    @Override
    public void awakeOnRem() throws ContradictionException {
        do {
            this.updateBoundInf(this.minInf());
        } while (this.remFromEnveloppe());
        this.onlyOneCandidatePropagation();
    }

    @Override
    public void awakeOnKer() throws ContradictionException {
        this.updateBoundSup(this.minSup());
        this.onlyOneCandidatePropagation();
    }

    @Override
    protected int getSatisfiedValue(DisposableIntIterator iter) {
        int v = Integer.MAX_VALUE;
        do {
            v = Math.min(v, this.ivars[1 + iter.next()].getVal());
        } while (iter.hasNext());
        iter.dispose();
        return v;
    }

    @Override
    public String pretty() {
        return this.pretty("min");
    }
}

