% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_option.R
\name{Some}
\alias{Some}
\title{Create an 'Some' Option}
\usage{
Some(x)
}
\arguments{
\item{x}{Object to be wrapped in the Enum variant.}
}
\value{
a list with a single value \code{x} and classes \code{"Option} and \code{"Enum}
}
\description{
Create an Enum variant of \code{Option} used to denote that function returned a value.
This allows the creation of safer functions that extract values from other objects, without using
\code{try} or \code{tryCatch}.
}
\examples{
subset_safe <- function(x, index) {
  if (index > length(x)){ return(None) }
  Some(x[index])
}

}
