% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{is.variant}
\alias{is.variant}
\title{Check Enum Variant}
\usage{
is.variant(x, variant, ...)
}
\arguments{
\item{x}{object to be tested}

\item{variant}{character string denoting variant to check.}

\item{...}{objects passed to methods}
}
\value{
\code{TRUE} if \code{x} is enumerated type of variant \code{variant}, \code{FALSE} otherwise
}
\description{
Test whether \code{\link{Enum}} is variant \code{variant}.
}
\examples{
HelloEnum <- Enum(
  "HelloEnum",
  Hello,
  World
)

# TRUE
is.variant(HelloEnum$Hello, "Hello")

# FALSE
is.variant(HelloEnum$Hello, "World")
}
