% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{antidiag}
\alias{antidiag}
\alias{antidiag<-}
\title{Matrix antidiagonals}
\usage{
antidiag(x = as.numeric(c(1)), nrow = NULL, ncol = NULL)

antidiag(x) <- value
}
\arguments{
\item{x}{matrix, vector or 1D array, or missing.}

\item{nrow}{number of rows (optional; when x is not a matrix)}

\item{ncol}{number of columns (optional; when x is not a matrix)}

\item{value}{either a single value or a vector of length equal to that of the current antidiagonal.
Should be of a mode which can be coerced to that of x.}
}
\description{
Extract or replace the antidiagonal of a matrix,
or construct a antidiagonal matrix.
}
\examples{
# Extracting antidiag
antidiag(diag(3))
# Creating antidiagonal matrix
antidiag(7, 3, 3)
antidiag(1:5, 3, 3)
# Assigning antidiagonal
mat <- matrix(0, 3, 3)
antidiag(mat) <- c(3, 4, 5)
mat
}
