% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hubert_t.R
\name{matrixStrucTestSub}
\alias{matrixStrucTestSub}
\title{Compute Gamma and t-statistics for a single permutation}
\usage{
matrixStrucTestSub(A, group_list_ord, Delta, multi_group_ind, A_upper_ind,
  K)
}
\arguments{
\item{A}{Distance or similarity matrix, e.g. correlation}

\item{group_list_ord}{List of groupings for ordered matrix A}

\item{Delta}{Delta matrix}

\item{multi_group_ind}{List of indicator matrices for membership in block k test}

\item{A_upper_ind}{indicator matrix for upper triangular elements}

\item{K}{Total number of hypothesized blocks}
}
\value{
Gamma_overall: Overall Hubert's Gamma

Gamma_multi: Block-specific Hubert's Gamma

t_overall: Overall t-statistic (unequal variance)

t_multi: Block-specific t-statistics

Ak_list: List of values in A used for each block-specific test

Deltak_list: List of values in Delta used for each block-specific test

A_upper: Upper triangular elements of A (used for box plot function)

Delta_upper: Upper triangular elements of Delta (used for box plot function)
}
\description{
This sub-routine is called by \code{matrixStrucTest} and \code{prepBoxPlots}.
}
