% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.bivdph.R
\name{fit,bivdph-method}
\alias{fit,bivdph-method}
\title{Fit method for bivdph Class}
\usage{
\S4method{fit}{bivdph}(x, y, weight = numeric(0), stepsEM = 1000, every = 10)
}
\arguments{
\item{x}{An object of class \linkS4class{bivdph}.}

\item{y}{A matrix with the data.}

\item{weight}{Vector of weights.}

\item{stepsEM}{Number of EM steps to be performed.}

\item{every}{Number of iterations between likelihood display updates.}
}
\value{
An object of class \linkS4class{bivdph}.
}
\description{
Fit method for bivdph Class
}
\examples{
obj <- bivdph(dimensions = c(3, 3))
data <- sim(obj, n = 100)
fit(obj, data, stepsEM = 100, every = 50)
}
