% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b.miph.R
\name{sim,miph-method}
\alias{sim,miph-method}
\title{Simulation method for inhomogeneous multivariate phase-type distributions}
\usage{
\S4method{sim}{miph}(x, n = 1000)
}
\arguments{
\item{x}{An object of class \linkS4class{miph}.}

\item{n}{An integer of length of realization.}
}
\value{
A realization of independent and identically distributed inhomogeneous
multivariate phase-type variables. If x is a MoE miph an array of dimension c(n,d,m) is returned,
with d the number of marginals and m the number of initial distribution vectors.
}
\description{
Simulation method for inhomogeneous multivariate phase-type distributions
}
\examples{
under_mph <- mph(structure = c("general", "general"))
obj <- miph(under_mph, gfun = c("weibull", "pareto"), gfun_pars = list(c(2), c(3)))
sim(obj, 100)
}
