% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_matrix}
\alias{export_matrix}
\title{Export a Data Matrix to Various File Formats}
\usage{
export_matrix(
  .data,
  file,
  format = NULL,
  drop_extra = FALSE,
  extra_columns = NULL,
  silent = FALSE,
  ...
)
}
\arguments{
\item{.data}{A data frame or tibble to be exported.}

\item{file}{A character string specifying the file name and path.}

\item{format}{A character string specifying the file format. If `NULL`, the format is inferred from the file extension.
Supported formats: `"csv"`, `"tsv"`, `"rds"`, `"xlsx"`, `"txt"`.}

\item{drop_extra}{Logical. If `TRUE`, removes columns not listed in `extra_columns` before exporting. Default is `FALSE`.}

\item{extra_columns}{A character vector specifying additional columns to retain if `drop_extra = TRUE`. Default is `NULL`.}

\item{silent}{Logical. If `TRUE`, suppresses messages. Default is `FALSE`.}

\item{...}{Additional arguments passed to the underlying export functions (`write.csv`, `writexl::write_xlsx`, etc.).}
}
\value{
Exports the data to a file and returns `NULL` invisibly.
}
\description{
This function exports a data frame to a specified file format, including CSV, TSV, RDS, XLSX, and TXT.
If the format is not provided, it is inferred from the file extension.
}
