% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_matrix}
\alias{merge_matrix}
\title{Merge Two literature matrices by Common Columns}
\usage{
merge_matrix(
  .data,
  .data2,
  by = NULL,
  all = FALSE,
  remove_dups = TRUE,
  suffixes = c(".x", ".y"),
  silent = FALSE
)
}
\arguments{
\item{.data}{A data frame to be merged.}

\item{.data2}{A second data frame to be merged with `.data`.}

\item{by}{A character vector specifying the column(s) to merge by. Must exist in both data frames.}

\item{all}{A logical value indicating whether to perform a full join (`TRUE`) or an inner join (`FALSE`, default).}

\item{remove_dups}{A logical value indicating whether to remove duplicate columns before merging. Default is `TRUE`.}

\item{suffixes}{A character vector of length 2 specifying suffixes to apply to overlapping column names
from `.data` and `.data2`, respectively. Default is `c(".x", ".y")`.}

\item{silent}{A logical value indicating whether to suppress messages about duplicate column removal. Default is `FALSE`.}
}
\value{
A merged data frame with specified join conditions applied.
}
\description{
This function merges two literature matrices based on specified key columns, with options for
full or inner joins and duplicate column removal.
}
\details{
The function first ensures that `.data` and `.data2` are valid data frames and checks
that the `by` columns exist in both. If `remove_dups = TRUE`, duplicate columns are
removed before merging. The function then performs either a full or inner join using
`dplyr::full_join()` or `dplyr::inner_join()`, respectively.
}
\examples{
df1 <- data.frame(id = c(1, 2, 3), value1 = c("A", "B", "C"))
df2 <- data.frame(id = c(2, 3, 4), value2 = c("X", "Y", "Z"))

# Inner join (default)
merge_matrix(df1, df2, by = "id")

# Full join
merge_matrix(df1, df2, by = "id", all = TRUE)

# Remove duplicate columns before merging
df3 <- data.frame(id = c(1, 2, 3), value1 = c("A", "B", "C"), extra = c(1, 2, 3))
df4 <- data.frame(id = c(2, 3, 4), value2 = c("X", "Y", "Z"), extra = c(4, 5, 6))
merge_matrix(df3, df4, by = "id", remove_dups = TRUE)

}
