#' A sample dataset for demostration purposes.
#'
#' @details
#' A data frame containing unreal sample data for demostration purposes only. It also serves as an example for a template of how user collected data should look.
#' Use this dataset to learn about the functions on this package.
#'
#' @format Data frame with 13 variables and 20 observations:
#' \describe{
#'    \item{Athlete}{A character string. Name of the subjects.}
#'    \item{`Date of Birth`}{A date object referring to the DOB for each athlete.}
#'    \item{`Testing Date`}{A date object referring to the date of testing of each athlete.}
#'    \item{Gender}{A character string. Refers to Male or Female.}
#'    \item{`Weight1 (KG)`}{A number. Weight in kgs. Measurement 1.}
#'    \item{`Weight2 (KG)`}{A number. Weight in kgs. Measurement 2.}
#'    \item{`Height1 (CM)`}{A number. Height in cms. Measurement 1.}
#'    \item{`Height2 (CM)`}{A number. Height in cms. Measurement 2.}
#'    \item{`Sitting Height1 (CM)`}{A number. Length of the trunk in cms for a seated measurement. Measurement 1.}
#'    \item{`Sitting Height2 (CM)`}{A number. Length of the trunk in cms for a seated measurement. Measurement 2.}
#'    \item{`Bench Height2 (CM)`}{A number. If the sitting height is done using a chair or a bench, indicate its length, otherwise use 0.}
#'    \item{`Mothers Height (CM)`}{A number. The standing height of the athlete's mother in cms.}
#'    \item{`Fathers Height (CM)`}{A number. The standing height of the athlete's father in cms.}
#'
#' }
#' @usage data_sample
#'

"data_sample"
