% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read.Tree.R
\name{Read.Tree}
\alias{Read.Tree}
\title{Evaluate utilities}
\usage{
Read.Tree(file, skip, nrows)
}
\arguments{
\item{file}{input csv file containing the tree.}

\item{skip}{starting row for read.}

\item{nrows}{number of rows to read.}
}
\value{
data.table with utilities.
}
\description{
Read a csv file where the decision tree is defined.
}
\examples{
library( data.table )
library( igraph )
file<-system.file("extdata", "tree.csv", package = "mau" )
sheetIndex<-1
tree.data<-Read.Tree( file, skip = 0, nrows = 8 )
}
\seealso{
\code{\link{Read.Utilities}}, \code{\link{Make.Decision.Tree}}
}
\author{
Pedro Guarderas, Andrés Lopez
}
