% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggspaghetti.R
\name{ggspaghetti}
\alias{ggspaghetti}
\alias{ggspaghetti.mc}
\alias{ggspaghetti.mcnode}
\title{Spaghetti Plot of `mc` or `mcnode` Object}
\usage{
ggspaghetti(x, ...)

\method{ggspaghetti}{mc}(
  x,
  griddim = NULL,
  xlab = names(x),
  ylab = "F(n)",
  main = "",
  maxlines = 100,
  ...
)

\method{ggspaghetti}{mcnode}(
  x,
  griddim = NULL,
  xlab = names(x),
  ylab = "F(n)",
  main = "",
  which = NULL,
  maxlines = 100,
  ...
)
}
\arguments{
\item{x}{an `mc` or an `mcnode` object}

\item{...}{further arguments to be passed to [ggplot2::stat_ecdf()]}

\item{griddim}{a vector of two integers, indicating the size of the grid of the graph. If `NULL`, the grid is calculated to produce a "nice" graph.}

\item{xlab}{vector of labels for the x-axis. If `NULL`, use the name of the node.}

\item{ylab}{vector of labels for the y-axis.}

\item{main}{vector of main titles of the graph}

\item{maxlines}{the maximum number of ecdf to draw.}

\item{which}{An argument used for an `mcnode` with multivariates. 
Can specify which variate plot to display. When variates are more than one, 
the output will be saved in a plot list by default or use the number of which variate to display.}
}
\description{
Use ggplot to draw spaghetti plots for the [mc] or [mcnode] objects.
}
\examples{
data(ec)
EC2 <- evalmcmod(ec[[2]])
# When the input is mc object
ggspaghetti(EC2) 
# When the input is mcnode object
data(total)
# mcnode has one variate
ggspaghetti(xV) 
# This mcnode has two variates, will save two plots in a list
gplots <- ggplotmc(xVUM) #will save two plots in a list
# show the first variate plot of xVUM mcnode
gplots[[1]] 
# directly show the first variate plot of xVUM mcnode
ggspaghetti(xVUM, which = 1) 

}
\author{
Yu Chen and Regis Pouillot
}
