% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triang.R
\name{triangular}
\alias{triangular}
\alias{dtriang}
\alias{ptriang}
\alias{qtriang}
\alias{rtriang}
\title{The Triangular Distribution}
\usage{
dtriang(x, min = -1, mode = 0, max = 1, log = FALSE, mean = 0)

ptriang(
  q,
  min = -1,
  mode = 0,
  max = 1,
  lower.tail = TRUE,
  log.p = FALSE,
  mean = 0
)

qtriang(
  p,
  min = -1,
  mode = 0,
  max = 1,
  lower.tail = TRUE,
  log.p = FALSE,
  mean = 0
)

rtriang(n, min = -1, mode = 0, max = 1, mean = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{min}{vector of minima.}

\item{mode}{vector of modes.}

\item{max}{vector of maxima.}

\item{log, log.p}{logical; if \samp{TRUE}, probabilities \samp{p} are given as \samp{log(p)}.}

\item{mean}{Vector of means, can be specified in place of \samp{mode} as an alternative parametrization.}

\item{lower.tail}{logical; if \samp{TRUE} (default), probabilities are \samp{P[X <= x]}, otherwise, \samp{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
\samp{dtriang} gives the density, \samp{ptriang} gives the distribution function,
\samp{qtriang} gives the quantile function, and \samp{rtriang} generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation
for the triangular distribution with minimum equal to \samp{min}, mode equal \samp{mode}
(alternatively, mean equal \samp{mean}) and maximum equal to \samp{max}.
}
\details{
If \samp{min == mode == max}, there is no density in that case and 
\samp{dtriang} will return \samp{NaN} (the error condition) (Similarity with \code{\link[stats]{Uniform}}).

\samp{mode} or \samp{mean} can be specified, but not both. Note: \samp{mean} is the last parameter for back-compatibility.
A warning will be provided if some combinations of \samp{min}, \samp{mean} and \samp{max} leads to impossible mode.
}
\examples{
curve(dtriang(x, min=3, mode=6, max=10), from = 2, to = 11, ylab="density")
## Alternative parametrization
curve(dtriang(x, min=3, mean=6, max=10), from = 2, to = 11, add=TRUE, lty=2)
##no density when  min == mode == max
dtriang(c(1,2,3),min=2,mode=2,max=2)
}
\keyword{distribution}
