% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genRandomSpanningTrees.R
\name{genRandomSpanningTree}
\alias{genRandomSpanningTree}
\title{Generate a random spanning tree.}
\usage{
genRandomSpanningTree(n, type = "pruefer")
}
\arguments{
\item{n}{[\code{integer}]\cr
Number of nodes of the problem.}

\item{type}{[\code{character(1)}]\cr
String representing the desired format of the generated
spanning tree. Possible values are \dQuote{pruefer} (Pruefer-code),
\dQuote{edgelist} and \dQuote{charvec} (characteristic vector).
Default is \dQuote{pruefer}.}
}
\value{
[\code{integer} | \code{matrix(2, n)}] Return type depends on \code{type}.
}
\description{
Generate a random spanning tree of a graph
given the number of nodes of the problem instance.
}
\examples{
genRandomSpanningTree(10)
genRandomSpanningTree(10, type = "edgelist")
}
