% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{getCommonSubtrees}
\alias{getCommonSubtrees}
\title{Get common subtrees of two trees.}
\usage{
getCommonSubtrees(x, y, n = NULL)
}
\arguments{
\item{x}{[\code{matrix}]\cr
Edge list of first tree.}

\item{y}{[\code{matrix}]\cr
Edge list of second tree.}

\item{n}{[\code{integer(1)} | \code{NULL}]\cr
Number of nodes.
Default to \code{ncol(x) + 1}.}
}
\value{
[\code{list}] List of matrizes. Each matrix contains the edges of one
  connected subtree.
}
\description{
Given two spanning trees, the function returns the subtrees
of the intersection of these.
}
\examples{
# assume we have a graph with n = 10 nodes
n.nodes = 10
# we define two trees (matrices with colwise edges)
stree1 = matrix(c(1, 2, 1, 3, 2, 4, 5, 6, 6, 7), byrow = FALSE, nrow = 2)
stree2 = matrix(c(1, 3, 1, 2, 2, 4, 5, 8, 6, 7), byrow = FALSE, nrow = 2)
# ... and compute all common subtrees
subtrees = getCommonSubtrees(stree1, stree2, n = 10)
}
