% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{nodelistToEdgelist}
\alias{nodelistToEdgelist}
\title{Convert sequence of nodes to edge list.}
\usage{
nodelistToEdgelist(nodelist)
}
\arguments{
\item{nodelist}{[\code{integer}]\cr
Sequence of nodes.}
}
\value{
[\code{matrix}] Edge list.
}
\description{
Convert sequence of nodes to edge list.
}
\examples{
# first generate a random permutation, e.g., representing
# a roundtrip tour in a graph
nodelist = sample(1:8)
# now convert into an edge list
nodelistToEdgelist(nodelist)
}
\seealso{
Other transformation functions: 
\code{\link{charVecToEdgelist}()},
\code{\link{edgeListToCharVec}()},
\code{\link{permutationToCharVec}()},
\code{\link{permutationToEdgelist}()},
\code{\link{prueferToCharVec}()},
\code{\link{prueferToEdgeList}()}
}
\concept{transformation functions}
