% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEdgeFrequency.R
\name{plotEdgeFrequency}
\alias{plotEdgeFrequency}
\title{Visualization of edge frequency among solution set.}
\usage{
plotEdgeFrequency(graphs, approx.sets, facet.args = list(), names = NULL)
}
\arguments{
\item{graphs}{[\code{list(grapherator)}]\cr
List of \code{\link[grapherator]{grapherator}} graphs.}

\item{approx.sets}{[\code{list(list(matrix))}]\cr
List of approximations sets.}

\item{facet.args}{[\code{list}]\cr
Further arguments passed down to \code{\link[ggplot2]{facet_wrap}}.
Only relevant if \code{length(graphs) > 1}.}

\item{names}{[\code{character}]\cr
Optional names of the graph instances. Used for facetting. Default is
\dQuote{Problem_i} with i ranging from 1 to \code{length(graphs)}.}
}
\value{
[\code{\link[ggplot2]{ggplot}}]
}
\description{
Given a list of graphs and a list of solutions (encoded as edge
lists) for each graph the function generates each one plot. This is a
2D-scatterplot of edge weights of the graph. Size and colour of each point
indicate the number of solutions the edge is part of.
}
\examples{
g = genRandomMCGP(50L)
res = mcMSTEmoaBG(mu = 10L, max.iter = 50, instance = g, scalarize = TRUE)
\dontrun{
plotEdgeFrequency(list(g), list(res$pareto.set))
}
}
\seealso{
Other result visualization: 
\code{\link{plotEdges}()}
}
\concept{result visualization}
