% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_lagr_tri.R
\name{.cor_lagr_tri}
\alias{.cor_lagr_tri}
\title{Calculate Lagrangian correlation of the triangular form}
\usage{
.cor_lagr_tri(v1, v2, k = 2, h1, h2, u)
}
\arguments{
\item{v1}{Prevailing wind, u-component.}

\item{v2}{Prevailing wind, v-component.}

\item{k}{Scale parameter of \eqn{\|\boldsymbol v\|}, \eqn{k>0}. Default is 2.}

\item{h1}{Horizontal distance matrix or array.}

\item{h2}{Vertical distance matrix or array, same dimension as \code{h1}.}

\item{u}{Time lag, same dimension as \code{h1}.}
}
\value{
Correlations of the same dimension as \code{h1}.
}
\description{
Calculate Lagrangian correlation of the triangular form
}
\details{
The Lagrangian correlation function of the triangular form with parameters
\eqn{\boldsymbol v = (v_1, v_2)^\top\in\mathbb{R}^2} has the form
\deqn{C(\mathbf{h}, u)=\left(1-\dfrac{1}{k\|\boldsymbol v\|}
\left|\dfrac{\mathbf{h}^\top\boldsymbol v}{\|\boldsymbol v\|}-
u\|\boldsymbol v\|\right|\right)_+,}
where \eqn{\|\cdot\|} is the Euclidean distance, \eqn{x_+=\max(x,0),
\mathbf{h} = (\mathrm{h}_1, \mathrm{h}_2)^\top\in\mathbb{R}^2},
and \eqn{k > 0} is the scale parameter controlling the magnitude of
asymmetry in correlation.
}
\keyword{internal}
