% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/re.R, R/tokenize.R
\name{as_character}
\alias{as_character}
\alias{as_character.default}
\alias{as_character.re}
\alias{as_character.tokens}
\title{Coerce object to character}
\usage{
as_character(x, ...)

\method{as_character}{default}(x, ...)

\method{as_character}{re}(x, ...)

\method{as_character}{tokens}(x, ...)
}
\arguments{
\item{x}{Object to coerce to character}

\item{...}{Additional arguments}
}
\value{
Object of class character
}
\description{
This method turns its argument \code{x}, or at least part of the information in it,
into a character vector.
}
\examples{
(tks <- tokenize("The old man and the sea."))
as_character(tks) # turn 'tokens' object into character vector
as.character(tks) # alternative approach

as_character(1:10)
as.character(1:10)

regex <- re("(?xi) ^ .*")
as_character(regex) # turn 're' object into character vector
as.character(regex) # alternative approach
}
