% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re.R
\name{scan_re}
\alias{scan_re}
\alias{scan_re2}
\title{Scan a regular expression from console}
\usage{
scan_re(perl = TRUE, ...)

scan_re2(perl = TRUE, ...)
}
\arguments{
\item{perl}{Logical. If \code{TRUE}, the regular expression being scanned is assumed
to use PCRE (Perl Compatible Regular Expressions) notation. If \code{FALSE}, it
is assumed to use base R's default regular expression notation (see \link[base:regex]{base::regex}).
Contrary to base R's regular expression functions, the default is \code{TRUE}.}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{\link{re}}.
}
\description{
The functions \code{\link[=scan_re]{scan_re()}} and \code{\link[=scan_re2]{scan_re2()}} can be used to scan a regular
expression from the console.
}
\details{
After the function call, R will continue scanning your input until it
encounters an empty input line, i.e. until it encounters two consecutive
newline symbols (or until it encounters a line with nothing but whitespace
characters). In other words, press ENTER twice in a row if you want to stop
inputting characters. The function will then return your input as a character vector
of length one.

These functions are designed to allow you to input complex text, in particular
regular expressions, without dealing with the restrictions of string literals,
such as having to use \verb{\\\\} for \verb{\\}.
}
\seealso{
\code{\link[=scan_txt]{scan_txt()}}, \code{\link[=cat_re]{cat_re()}}
}
