% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_txt}
\alias{write_txt}
\title{Write a character vector to a text file}
\usage{
write_txt(x, file = "", line_glue = "\\n")
}
\arguments{
\item{x}{A character vector.}

\item{file}{Name of the output file.}

\item{line_glue}{Character string to be used as end-of-line marker on disk
or \code{NA} for no end-of-line marker (so that \code{x} becomes a single line).}
}
\value{
Invisibly, \code{x}.
}
\description{
This function writes a character vector to a text file. By default, each
item in the character vector becomes a line in the text file.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
x <- "This is
a small
text."

# write the text to a text file
write_txt(x, "example-text-file.txt")
# read a text from file
y <- read_txt("example-text-file.txt")
y
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=read_txt]{read_txt()}}

Other writing functions: 
\code{\link{write_assoc}()},
\code{\link{write_conc}()},
\code{\link{write_fnames}()},
\code{\link{write_freqlist}()},
\code{\link{write_tokens}()},
\code{\link{write_types}()}
}
\concept{writing functions}
