% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logitnorm.R
\name{mcmap_logitnorm}
\alias{mcmap_logitnorm}
\title{Mapper function for logit-normal distribution}
\usage{
mcmap_logitnorm(
  target = c(m = 0.25, c = 0.75),
  method = "",
  integrate_controls = list(),
  optim_controls = list()
)
}
\arguments{
\item{target}{A vector of size 2. The first element is mean and the second element is c-statistic.}

\item{method}{Either empty string, which invoked the default method; or "meansolve" which uses two 1-dimensional optimization approach.}

\item{integrate_controls}{(optional): parameters to be passed to integrate()}

\item{optim_controls}{(optional): parameters to be passed to optim()}
}
\value{
A vector of size two that contains the distribution parameters
}
\description{
Maps a pair of mean and c-statistic value to the parameters of a logit-normal distribution
}
\examples{
mcmap_logitnorm(c(0.1, 0.75))
}
