% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_s.R
\name{s}
\alias{s}
\title{Specify a smooth term component of the linear predictor}
\usage{
s(..., unit.precision = FALSE, name = "", debug = FALSE)
}
\arguments{
\item{...}{parameters passed to \code{mgcv::s}. Note that
variables appearing in \code{...} must be present in the data frame
passed to the data argument of \code{\link{create_sampler}} or
\code{\link{generate_data}}.}

\item{unit.precision}{to be implemented.}

\item{name}{the name of the model component. By default  the name will be 's'
with the number of the model term attached. This name is used in the output
of the MCMC simulation function \code{\link{MCMCsim}}. The name is appended
by '_f' for any unpenalised (fixed) effects, if any, and by '_r' for the
penalised (random) effects.}

\item{debug}{if \code{TRUE} a breakpoint is set at the beginning of the posterior
draw function associated with this model component. Mainly intended for developers.}
}
\value{
An object with precomputed quantities and functions for sampling from
 prior or conditional posterior distributions for this model component,
 intended for internal use by other package functions.
}
\description{
This function can be used inside the formula specification
of the linear predictor in \code{\link{create_sampler}} or
\code{\link{generate_data}}. The smooth term is set up by
the smooth term specification function \code{\link[mgcv]{s}}
of package \pkg{mgcv}. The smooth term is usually composed
of random (penalised) effects as well as a few fixed
(unpenalised) effects, not including an intercept.
}
\examples{
\dontrun{
library(mgcv)
set.seed(0)
dat <- gamSim(5, n=200, scale=2)
b <- gam(y ~ x0 + s(x1) + s(x2) + s(x3), data=dat)

sampler <- create_sampler(
  y ~ x0 + s(x1) + s(x2) + s(x3), data=dat
)
sim <- MCMCsim(sampler, store.all=TRUE)
(summ <- summary(sim))
plot(
  coef(b),
  c(summ$reg1[, "Mean"],
    summ$s2_r[, "Mean"], summ$s2_f[, "Mean"],
    summ$s3_r[, "Mean"], summ$s3_f[, "Mean"],
    summ$s4_r[, "Mean"], summ$s4_f[, "Mean"]
   )
); abline(0, 1)
predb <- predict(b, newdata=dat[1:5, ])
pred <- predict(sim, newdata=dat[1:5, ], type="response")
(summpred <- summary(pred))
plot(predb, summpred[, "Mean"]); abline(0, 1)
}

}
\references{
S.N. Wood (2017).
   Generalized additive models: an introduction with R.
   Chapman and Hall/CRC.
}
