% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc.R
\name{descvar}
\alias{descvar}
\title{Summarize Descriptive Statistics}
\usage{
descvar(
  data,
  var,
  bygroup,
  stats = getOption("mcradds.stats.default"),
  autodecimal = TRUE,
  decimal = 1,
  addtot = FALSE,
  .perctype = 2
)
}
\arguments{
\item{data}{(\code{data.frame})\cr a data frame that contains the variables to be
summarized and grouped.}

\item{var}{(\code{vector})\cr a character vector of variables to be summarized within \code{data}.}

\item{bygroup}{(\code{string})\cr a character variable for grouping within \code{data}.}

\item{stats}{(\code{vector})\cr a statistics character vector must be chosen from
c("N", "MEAN", "SD", "MEDIAN", "MAX", "MIN", "Q1", "Q3", "MEANSD", "RANGE",
"IQR", "MEDRANGE", "MEDIQR"), and the default are top six items.}

\item{autodecimal}{(\code{logical})\cr whether to capture the variable's maximum
decimal, and the final decimal precision is equal to the variable decimal plus
the definition of each statistic from \code{getOption("mcradds.precision.default")}.}

\item{decimal}{(\code{integer})\cr a integer number to define the decimal precision
for each variable.}

\item{addtot}{(\code{logical})\cr whether to add total column in the output or not.}

\item{.perctype}{(\code{integer})\cr an integer between 1 and 9 selecting one of
the nine quantile algorithms, also see the details in \code{\link[=quantile]{quantile()}}. The default
is \code{2}, so that it can be consistent with SAS quantile calculation.}
}
\value{
A object \code{Desc} contains an intermediate data with long form for
post-processing and final data with wide form for presentation.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Create a summary table with a set of descriptive statistics for one or more
variables by one group, as well as a total column if necessary.
}
\note{
The decimal precision is based on two aspects, one is the original precision
from the variable or the \code{decimal} argument, and the second is the common use that
has been defined in \code{getOption("mcradds.precision.default")}. So if you want to
change the second decimal precision, you can alter it manually with \code{option()}.
}
\examples{
data(adsl_sub)

# Compute the default statistics of AGE by TRTP group
adsl_sub \%>\%
  descvar(
    var = "AGE",
    bygroup = "TRTP"
  )

# Compute the specific statistics of BMI by TRTP group, adding total column
adsl_sub \%>\%
  descvar(
    var = "BMIBL",
    bygroup = "TRTP",
    stats = c("N", "MEANSD", "MEDIAN", "RANGE", "IQR"),
    addtot = TRUE
  )

# Set extra decimal to define precision
adsl_sub \%>\%
  descvar(
    var = "BMIBL",
    bygroup = "TRTP",
    stats = c("N", "MEANSD", "MEDIAN", "RANGE", "IQR"),
    autodecimal = FALSE,
    decimal = 2,
    addtot = TRUE
  )

# Set multiple variables together
adsl_sub \%>\%
  descvar(
    var = c("AGE", "BMIBL", "HEIGHTBL"),
    bygroup = "TRTP",
    stats = c("N", "MEANSD", "MEDIAN", "RANGE", "IQR"),
    autodecimal = TRUE,
    addtot = TRUE
  )
}
