% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{combine_df}
\alias{combine_df}
\title{Combine Dataframes in a Nested List}
\usage{
combine_df(nested_list)
}
\arguments{
\item{nested_list}{A list of lists, where each sublist contains dataframes to be combined.}
}
\value{
A combined dataframe where each original dataframe is augmented with an ID column indicating its source list.
}
\description{
This function combines dataframes that are nested within a list of lists into a single dataframe.
}
\details{
The function first checks if the input is a non-empty list of lists containing dataframes.
It then iterates through each sublist, combining the dataframes and adding an ID column to indicate their source.
Finally, all combined dataframes are row-bound into a single dataframe.
}
\examples{
df1 <- data.frame(a = 1:3, b = 4:6)
df2 <- data.frame(a = 7:9, b = 10:12)
nested_list <- list(list(df1, df2), list(df1, df2))
combine_df(nested_list)
}
