% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{NCI60_tiny}
\alias{NCI60_tiny}
\alias{Cancer}
\title{Gene expression in cancer}
\format{
The expression data, \link{NCI60_tiny} is a dataframe of 41,078 gene probes (rows)
and 60 cell lines (columns).  The first column, \code{Probe} gives the name
of the Agilent microarray probe.  Each of the remaining columns is named for
a cell line.  The value is the log-2 expression associated with that probe
for the cell line.

\describe{
\item{Probe}{the name of the Agilent microarray probe}
}

For \link{Cancer}:
\describe{
\item{otherCellLine}{a character vector giving the name of one cell line}
\item{cellLine}{a character vector giving the name of another cell line}
\item{correlation}{the correlation between the two cell lines. See \code{\link[stats:cor]{stats::cor()}}}
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1770 rows and 3 columns.
}
\usage{
NCI60_tiny

Cancer
}
\description{
The data come from a National Cancer Institute study of gene expression in
cell lines drawn from various sorts of cancer.
}
\details{
\link{Cancer} gives information about each cell line.
}
\examples{
data(NCI60_tiny) 

}
\references{
\itemize{
\item Staunton et al. (2001), \emph{PNAS} (\doi{10.1073/pnas.191368598})
\item D.T. Ross et al. (2000) \emph{Nature Genetics}, 24(3):227-234 (\doi{10.1038/73432})
\item \href{https://discover.nci.nih.gov/cellminer/}{CellMiner}
}
}
\seealso{
\link{Cancer}
}
\keyword{datasets}
