% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{root}
\alias{root}
\alias{root_conicDistribution}
\alias{root_ldrDistribution}
\alias{root_individualRootedGroundArea}
\alias{root_specificRootSurfaceArea}
\alias{root_fineRootRadius}
\alias{root_fineRootHalfDistance}
\alias{root_fineRootAreaIndex}
\alias{root_fineRootBiomass}
\alias{root_rhizosphereMaximumConductance}
\alias{root_fineRootSoilVolume}
\alias{root_coarseRootSoilVolumeFromConductance}
\alias{root_coarseRootLengthsFromVolume}
\alias{root_coarseRootLengths}
\alias{root_coarseRootSoilVolume}
\alias{root_horizontalProportions}
\title{Root functions}
\usage{
root_conicDistribution(Zcone, d)

root_ldrDistribution(Z50, Z95, Z100, d)

root_individualRootedGroundArea(VolInd, V, d, rfc)

root_specificRootSurfaceArea(specificRootLength, rootTissueDensity)

root_fineRootRadius(specificRootLength, rootTissueDensity)

root_fineRootHalfDistance(rootLengthDensity)

root_fineRootAreaIndex(
  Ksoil,
  krhizo,
  lai,
  specificRootLength,
  rootTissueDensity,
  rootLengthDensity
)

root_fineRootBiomass(
  Ksoil,
  krhizo,
  lai,
  N,
  specificRootLength,
  rootTissueDensity,
  rootLengthDensity
)

root_rhizosphereMaximumConductance(
  Ksoil,
  fineRootBiomass,
  lai,
  N,
  specificRootLength,
  rootTissueDensity,
  rootLengthDensity
)

root_fineRootSoilVolume(fineRootBiomass, specificRootLength, rootLengthDensity)

root_coarseRootSoilVolumeFromConductance(
  Kmax_rootxylem,
  VCroot_kmax,
  Al2As,
  v,
  d,
  rfc
)

root_coarseRootLengthsFromVolume(VolInd, v, d, rfc)

root_coarseRootLengths(v, d, depthWidthRatio = 1)

root_coarseRootSoilVolume(v, d, depthWidthRatio = 1)

root_horizontalProportions(poolProportions, VolInd, N, V, d, rfc)
}
\arguments{
\item{Zcone}{A vector of depths (in mm) corresponding to the root cone tip.}

\item{d}{The width (in mm) corresponding to each soil layer.}

\item{Z50}{A vector of depths (in mm) corresponding to 50\% of roots.}

\item{Z95}{A vector of depths (in mm) corresponding to 95\% of roots.}

\item{Z100}{A vector of depths (in mm) corresponding to 100\% of roots.}

\item{VolInd}{Volume of soil (in m3) occupied by coarse roots per individual.}

\item{V}{Matrix of proportions of fine roots (cohorts x soil layers).}

\item{rfc}{Percentage of rock fragment content (volume basis) for each layer.}

\item{specificRootLength}{Specific fine root length (length of fine roots over weight).}

\item{rootTissueDensity}{Fine root tissue density (weight over volume at turgidity).}

\item{rootLengthDensity}{Fine root length density (length of fine roots over soil volume; cm/cm3)}

\item{Ksoil}{Soil saturated conductivity (mmol·m-1·s-1·MPa-1).}

\item{krhizo}{Rhizosphere maximum conductance per leaf area (mmol·m-2·s-1·MPa-1).}

\item{lai}{Leaf area index.}

\item{N}{Density of individuals per hectare.}

\item{fineRootBiomass}{Biomass of fine roots (g).}

\item{Kmax_rootxylem}{Sapwood-specific hydraulic conductivity of root xylem (in kg H2O·s-1·m-1·MPa-1).}

\item{VCroot_kmax}{Root xylem maximum conductance per leaf area (mmol·m-2·s-1·MPa-1).}

\item{Al2As}{Leaf area to sapwood area ratio (in m2·m-2).}

\item{v}{Vector of proportions of fine roots in each soil layer.}

\item{depthWidthRatio}{Ratio between radius of the soil layer with the largest radius and maximum rooting depth.}

\item{poolProportions}{Division of the stand area among plant cohorts (proportions).}
}
\value{
See details.
}
\description{
Functions to calculate properties of fine/coarse roots within the soil, given root system parameters and soil layer definition.
}
\details{
\itemize{
\item{\code{root_conicDistribution()} assumes a (vertical) conic distribution of fine roots, whereas \code{root_ldrDistribution()} distributes fine roots according to the linear dose response model of Schenck & Jackson (2002). Return a matrix of fine root proportions in each layer with as many rows as elements in \code{Z} (or \code{Z50}) and as many columns as soil layers.}
\item{\code{root_coarseRootLengths()} and \code{root_coarseRootLengthsFromVolume()} estimate the length of coarse roots (mm) for each soil layer, including axial and radial lengths.}
\item{\code{root_coarseRootSoilVolume} estimates the soil volume (m3) occupied by coarse roots of an individual.}
\item{\code{root_coarseRootSoilVolumeFromConductance} estimates the soil volume (m3) occupied by coarse roots of an individual from root xylem conductance.}
\item{\code{root_fineRootHalfDistance()} calculates the half distance (cm) between neighbouring fine roots.}
\item{\code{root_fineRootRadius()} calculates the radius of fine roots (cm).}
\item{\code{root_fineRootAreaIndex()} estimates the fine root area index for a given soil conductivity and maximum rhizosphere conductance.}
\item{\code{root_fineRootBiomass()} estimates the biomass of fine roots (g dry/individual) for a given soil conductivity and maximum rhizosphere conductance.}
\item{\code{root_rhizosphereMaximumConductance()} is the inverse of the preceeding function, i.e. it estimates rhizosphere conductance from soil conductivity and fine root biomass.}
\item{\code{root_fineRootSoilVolume()} calculates the soil volume (m3) occupied with fine roots.}
\item{\code{root_specificRootSurfaceArea()} returns the specific fine root area (cm2/g).}
\item{\code{root_individualRootedGroundArea()} calculates the area (m2) covered by roots of an individual, for each soil layer.}
\item{\code{root_horizontalProportions()} calculates the (horizontal) proportion of roots of each cohort in the water pool corresponding to itself and that of other cohorts, for each soil layer. Returns a list (with as many elements as cohorts) with each element being a matrix.}
}
}
\examples{
#Load example plot plant data
data(exampleforest)

#Default species parameterization
data(SpParamsMED)

ntree <- nrow(exampleforest$treeData)

#Initialize soil with default soil params
s <- defaultSoilParams(4)

#Calculate conic root system for trees
V1 <- root_conicDistribution(Z=rep(2000,ntree), s$widths)            
print(V1)
     
#Calculate LDR root system for trees (Schenck & Jackson 2002)
V2 <- root_ldrDistribution(Z50 = rep(200,ntree), 
                           Z95 = rep(1000,ntree),
                           Z100 = rep(NA, ntree), s$widths)
print(V2)     

}
\references{
Schenk, H., Jackson, R., 2002. The global biogeography of roots. Ecol. Monogr. 72, 311–328.

Sperry, J. S., Y. Wang, B. T. Wolfe, D. S. Mackay, W. R. L. Anderegg, N. G. Mcdowell, and W. T. Pockman. 2016. Pragmatic hydraulic theory predicts stomatal responses to climatic water deficits. New Phytologist 212, 577–589.
}
\seealso{
\code{\link{spwb}},  \code{\link{spwbInput}}, \code{\link{soil}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
\keyword{internal}
