% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediationsens.R
\name{sens}
\alias{sens}
\title{Simulation-Based Sensitivity Analysis Table for Causal Mediation Analysis}
\usage{
sens(
  y,
  t.rand = TRUE,
  t,
  m,
  covariates,
  scale.y,
  scale.m,
  scale.U,
  b.t = NULL,
  range.b.m = c(-2, 2),
  range.b.y = c(-1, 1),
  grid.b.y = 5,
  grid.b.m = 5,
  p.u = 0.5,
  sigma.u = 1,
  iter = 10,
  nsim = 40,
  est,
  B,
  data
)
}
\arguments{
\item{y}{The name of the outcome variable (string).}

\item{t.rand}{TRUE if the treatment is randomized, and FALSE if not. The default is TRUE.}

\item{t}{The name of the treatment variable (string). The treatment variable has to be binary.}

\item{m}{The name of the mediator variable (string).}

\item{covariates}{A vector of variable names (string) of pretreatment confounders, which will be included in the propensity score model. Transform each categorical variable into multiple binary indicators before specifying X.}

\item{scale.y}{The scale of the outcome variable (string). Can be "continuous" or "binary".}

\item{scale.m}{The scale of the mediator variable (string). Can be "continuous" or "binary".}

\item{scale.U}{The scale of the unobserved pretreatment confounder (string). Can be "continuous" or "binary".}

\item{b.t}{The value of the sensitivity parameter that represents the conditional association between the unobserved pretreatment confounder and the treatment. The default is NULL, because when the treatment is randomized, there is no need to specify this sensitivity parameter.}

\item{range.b.m}{The range of the sensitivity parameter that represents the conditional association between the unobserved pretreatment confounder and the mediator. The default is c(-2, 2).}

\item{range.b.y}{The range of the sensitivity parameter that represents the conditional association between the unobserved pretreatment confounder and the outcome. The default is c(-1, 1).}

\item{grid.b.y}{The vertical dimension of the grid. The default is 5. Increase the number for more smooth curves.}

\item{grid.b.m}{The horizontal dimension of the grid. The default is 5. Increase the number for more smooth curves.}

\item{p.u}{The prior probability of the unobserved pretreatment confounder if it is binary. The default is 0.5.}

\item{sigma.u}{The standard deviation of the prior distribution of the unobserved pretreatment confounder if it is continuous. The default is 1.}

\item{iter}{The number of iterations in the stochastic EM algorithm for generating the unobserved pretreatment confounder. The default is 10.}

\item{nsim}{The number of random draws of the unobserved pretreatment confounder in each cell. The default is 40. Increase the number for more smooth curves.}

\item{est}{The method to be used in the estimation of the causal mediation effects. "rmpw" uses the weighting-based method. It estimates the natural direct and indirect effects through mean contrasts of the outcome. When the outcome is coninuous, it controls for the pretreatment confounders in the outcome model for improving efficiency. When the outcome is binary, it cannot control for the pretreatment confounders. In addition to the scenario with a binary mediator and a continuous outcome, we use bootstrapping to estimate their standard errors and test their significance. "regression" uses the regression-based method developed by VanderWeele and Vansteelandt (2009). It is only applicable to continuous outcomes, because when the outcome is binary, the natural direct and indirect effects are identified on the odds ratio scale, rendering results difficult to report. Because the estimator of the natural direct effect or the natural indirect effect is a complex combination of regression coefficients and may not follow a normal distribution, we use bootstrapping to estimate their standard errors and test their significance. "simulation" uses the simulation-based method developed by Imai et al. (2010a, 2010b), and the mediation package is adopted. For a binary mediator or outcome, the link function is always specified to be logit. If t.rand = FALSE, i.e the treatment is not randomized, only rmpw is applicable.}

\item{B}{The number of bootstrapped samples in the causal mediation analysis if bootstrapping is used for estimating standard errors and testing significance.}

\item{data}{The data set for analysis.}
}
\value{
A list containing
\item{results.old}{the causal effect estimates in the original analysis.}
\item{X.coef.plot}{the coefficients of the observed pretreatment covariates in the mediator and outcome models (which are used to calibrate the strength of the sensitivity parameters in the sensitivity plots).}
\item{range.b.m, range.b.y}{same as specified in the sens function.}
\item{b.m.all, b.y.all}{all the specific values of the sensitivity parameters for constructing the grids.}
\item{results.new}{tables for the causal effect estimates, standard errors, and p values in all the grids, after the adjustment of the unobserved pretreatment confounder.}
}
\description{
This function is used to evaluate the sensitivity of the estimated natural direrct and indirect effects to potential violations of the ignorability assumptions. It estimates the natural direct and indirect effects after adjusting for an unmeasured pretreatment confounder, U, with a specified degree of confounding. In a randomized experiment, the degree of confounding is evaluated via two sensitivity parameters, the coefficient of U in the mediator model and that in the outcome model, given the specified prior distribution of U. When the treatment is not randomized, an additional sensitivity parameter is introduced -- the coefficient of U in the treatment model. The mediator, outcome, and unmeasured pretreatment confounder could be either binary or continuous, while the treatment has to be binary. If the treatment is randomized, the sensitivity analysis method is applicable to various causal mediation analysis methods, including the ratio of mediator probability weights (RMPW) method, the regression-based method proposed by VanderWeele (2010), and the simulation-based method proposed by Imai et al. (2010a, 2010b). If the treatment is not randomized, the method is applicable to the RMPW method. To reduce the risk of model misspecifications, we account for the interaction between the treatment and each observed pretreatment covariate in the mediator model.
}
\examples{
library(mediation)
data(jobs)
# Generate a binary outcome based on the median of the
# continuous outcome.
jobs$depress2_dich[jobs$depress2 >= median(jobs$depress2)] = 1
jobs$depress2_dich[jobs$depress2 < median(jobs$depress2)] = 0

sens.results = sens(y = "depress2", t = "treat", m = "job_seek",
    covariates = c("econ_hard", "depress1", "sex", "age"), scale.y = "continuous",
    scale.m = "continuous", scale.U = "binary", range.b.m = c(-2,
        2), range.b.y = c(-1, 1), grid.b.y = 2, grid.b.m = 1, p.u = 0.5,
    iter = 10, nsim = 10, est = "rmpw", B = 2, data = jobs)
}
\references{
Qin, X., & Yang, F. (2020). Simulation-Based Sensitivity Analysis for Causal Mediation Studies.

VanderWeele, T. J. (2010). Bias formulas for sensitivity analysis for direct and indirect effects. Epidemiology, 21, 540.

Imai, K., Keele, L., & Tingley, D. (2010a). A general approach to causal mediation analysis. Psychological Methods, 15, 309.

Imai, K., Keele, L., & Yamamoto, T. (2010b). Identification, inference and sensitivity analysis for causal mediation effects. Statistical Science, 25, 51-71.
}
\author{
Xu Qin and Fan Yang
}
