#' @title
#' RCT of Indomethacin for Prevention of Post-ERCP Pancreatitis
#'
#' @description
#' Results of a randomized, placebo-controlled, prospective 2-arm trial of rectal indomethacin (100 mg) vs. placebo prevent post-ERCP pancreatitis in 602 participants, as reported by Elmunzer, Higgins, et al. in 2012 in the New England Journal of Medicine (more details available below the variable definitions).
#'
#' @details
#' ERCP, or endoscopic retrograde cholangio-pancreatogram, is a procedure performed by threading an endoscope through the mouth to the opening in the duodenum where bile and pancreatic digestive juices are released into the intestine. ERCP is helpful for treating blockages of flow of bile (gallstones, cancer), or diagnosing cancers of the pancreas, but has a high rate of complications (15-25%). \cr
#' The occurrence of post-ERCP pancreatitis is a common and feared complication, as pancreatitis can result in multisystem organ failure and death, and can occur in ~ 16% of ERCP procedures. \cr
#' The inflammatory cytokine storm that can result from this procedural complication can be quite severe. Several small randomized trials suggested that anti-inflammatory NSAID therapies at the time of ERCP could reduce the rate of this complication, but all were rather small single-center studies, and were not sufficiently convincing to change practice. \cr
#' Elmunzer, Higgins, and colleagues performed a \href{https://pubmed.ncbi.nlm.nih.gov/18375470/}{meta-analysis} of these small trials, which suggested that this was a significant effect, and that indomethacin could result in a 64% reduction in post-ERCP pancreatitis. \cr
#' The investigators took this as a possible over-estimate of the effect (due to publication bias), and designed a multicenter RCT of a planned 948 patients to see a reduction of 50% from a placebo rate of 10% to an indomethacin rate of 5%. Two interim analyses were performed, after 400 and 600 patients were enrolled, using an alpha spending function. The Data and Safety Monitoring Board stopped the study after 602 participants were enrolled because of the significantly positive effect of indomethacin, which reduced post-ERCP pancreatitis from 16% in the placebo group to 9% in the indomethacin group. \cr
#' You can find the manuscript at \href{https://www.nejm.org/doi/full/10.1056/NEJMoa1111103}{Indomethacin to Prevent Post-ERCP Pancreatitis}. \cr
#'
#' @format A data frame with 602 observations and 33 variables
#' \describe{
#' \item{id}{subject id, first integer indicates center, integer, range:1001-4003}
#' \item{site}{study site (center), factor, 1 = University of Michigan, 2= Indiana University, 3 = University of Kentucky, 4 = Case Western}
#' \item{age}{age in years, numeric, range:  19-90}
#' \item{risk}{risk score, numeric, range:   1-5.5}
#' \item{gender}{male or female, factor, levels: 1_female, 2_male}
#' \item{sod}{sphincter of oddi dysfunction was present, a risk factor favoring post-ERCP pancreatitis, factor, levels: 0_no, 1_yes}
#' \item{pep}{previous post-ERCP pancreatitis (PEP), a risk factor for future PEP, factor, levels: 0_no, 1_yes}
#' \item{recpanc}{Recurrent Pancreatitis, a risk factor for future PEP, factor, levels: 0_no, 1_yes}
#' \item{psphinc}{a Pancreatic Sphincterotomy was performed, a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{precut}{a sphincter pre-cut was needed to enter the papilla, a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{difcan}{Cannulation of the papilla was difficult, a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{pneudil}{Pneumatic dilation of the papilla was performed, a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{amp}{An Ampullectomy was performed for dysplasia or cancer, which could be a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{paninj}{Contrast was injected into the pancreas during the procedure, a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{acinar}{The pancreas appeared to have acinarization on imaging, which could be a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{brush}{Brushings were taken from the pancreatic duct, a possible risk factor favoring post-ERCP pancreatitis. factor, levels: 0_no, 1_yes}
#' \item{asa81}{Aspirin was used at a dose of 81 mg per day, which may increase the risk of bleeding. factor, levels: 0_no, 1_yes}
#' \item{asa325}{Aspirin was used at a dose of 325 mg per day, which may increase the risk of bleeding. factor, levels: 0_no, 1_yes}
#' \item{asa}{Aspirin was used (at a dose of 325 mg per day(at any dose), which may increase the risk of bleeding. factor, levels: 0_no, 1_yes}
#' \item{prophystent}{A pancreatic duct stent was placed at the end of the procedure per the judgement of the endoscopist (more often in high-risk cases), a potential protective effect against PEP, factor, levels: 0_no, 1_yes}
#' \item{therastent}{A pancreatic duct stent was placed in order to treat a clinically significant narrowing of the pancreatic duct, a potential protective effect against PEP, factor, levels: 0_no, 1_yes}
#' \item{pdstent}{A pancreatic duct stent was placed at the end of the procedure for any reason, a potential protective effect against PEP, factor, levels: 0_no, 1_yes}
#' \item{sodsom}{Sphincter of oddi manometry was performed during the procedure for SOD, a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{bsphinc}{A biliary sphincterotomy was performed, which could be a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{bstent}{A biliary stent was placed to relieve significant biliary obstruction, factor, levels: 0_no, 1_yes}
#' \item{chole}{Choledocholithiasis (gallstones blocking the biliary duct) was present, factor, levels: 0_no, 1_yes}
#' \item{pbmal}{Malignancy of the biliary duct or pancreas was found, factor, levels: 0_no, 1_yes}
#' \item{train}{A trainee participated in the ERCP, which could be a risk factor for PEP, factor, levels: 0_no, 1_yes}
#' \item{outcome}{outcome of post-ercp pancreatitis, factor, levels: 0_no, 1_yes}
#' \item{status}{outpatient status, factor, levels: 0_inpatient, 1_outpatient}
#' \item{type}{Sphincter of Oddi dysfunction type/level - higher numbers are more severe with greater association with PEP, factor, levels: 0_no SOC, 1_type 1, 2_type 2, 3_type 3}
#' \item{rx}{treatment arm, factor, levels: 0_placebo, 1_indomethacin}
#' \item{bleed}{A gastrointestinal bleed occurred (which could be a complication of indomethacin therapy), factor, levels: 1. no, 2. yes}
#' }
#' @source This data set is sourced from the authors of the 2012 manuscript in the New England Journal of Medicine, entitled, A Randomized Trial of Rectal Indomethacin to Prevent Post-ERCP Pancreatitis, pages 1414-1422 volume 366, in the April 12, 2012 edition, authored by the Elmunzer, BJ, Higgins PDR, et al. You can find the manuscript at \href{https://www.nejm.org/doi/full/10.1056/NEJMoa1111103}{Indomethacin to Prevent Post-ERCP Pancreatitis}.
#'
"indo_rct"