% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{functionCall}
\alias{functionCall}
\title{Function Call}
\usage{
functionCall(f = sys.function(sys.parent()), call = sys.call(sys.parent()))
}
\arguments{
\item{f}{function, defaults to the containing function}

\item{call}{call, default to the containing call}
}
\value{
functionCall, a hashable form of the function call information
}
\description{
For a given function and call, return a list of class 'functionCall' which
can be hashed to provide a unique identifier for the function and parameters used for this call.
}
\examples{
# my example function
my.function <- function (x, y) x+y

# create a new function call
my.functionCall <- functionCall(my.function, call("my.function", 10, 10))

# the function and arguments are now available
my.functionCall$f
my.functionCall$args

# using the default argument values to get the function call of the containing function
my.function2 <- function (x, y) functionCall()
my.functionCall2 <- my.function2(10, 10)

# the function and arguments are now available
my.functionCall2$f
my.functionCall2$args
}
